﻿// TEXT2GLYPHS script
// created by Pert Vaclavek 2015
// version 1.0 (23. july 2015)
//
// more info: http://sellinggraphics.com/script-convert-text-to-vector-glyphs
// -------------------------------------------------------------------------------

function findletter (letter){
  l = null;
  letter = 'letter-'+ letter;
  var docRef = app.activeDocument; // aktuální dokument
    
  for (var k=0;k<docRef.pageItems.length; k++){
        if (letter == docRef.pageItems[k].name) {
            l = docRef.pageItems[k]; //.duplicate ();
            break;
        }
   }
   return (l);
}

function createletter (letter){
    l = findletter (letter);
    if (l) return (l.duplicate())
    else return null;
}

function setposition (letter){
    if (letter.name){
    lname = letter.name.charAt(letter.name.length-1);
    lw = letter.visibleBounds[2] - letter.visibleBounds[0];
    lh = letter.visibleBounds[1] - letter.visibleBounds[3];
    letter.top = lh-line;
    switch (lname) {
            case 'j': {
                li = findletter ('i');
                if (li) letter.top = li.visibleBounds[1] - li.visibleBounds[3]-line;
                break;
                }

            case 'Q': {
                lo = findletter ('O');
                if (lo) letter.top = lo.visibleBounds[1] - lo.visibleBounds[3]-line;
                break;
                }

            case 'g':
            case 'p':
            case 'q':
            case 'y': {
                letter.top -= lh-mh;
                break;
                }
        }
        letter.left = pos;
        pos += lw + letterspace;
    }
}


if(app.documents.length == 0){
	alert("Open or create some document first");
}  else {
    var docRef = app.activeDocument; // aktuální dokument
    var selectedItems = selection
    var newLayer = docRef.layers.add();
    var pos = 0;

    var letterspace = 0;
    var wordspace = 0;
    var linespace = 0;
    
    var lm = findletter('m');
    var um = findletter('M');

    if (um){
        letterspace = um.width / 5;
        wordspace = um.width;
        linespace = (3*(um.height))/2;
    }

    var mw = 0;
    var mh = 0;
    if (lm){
        mw = lm.width;
        mh = lm.height;
    }
    var line = 0;
        
    newLayer.name = "Converted text";
    if (selectedItems.length > 0) {
        for(var i=0; i<selectedItems.length; i++) {
            if (selectedItems[i].contents){
                toconvert = selectedItems[i].contents;
                for (var j=0;j<toconvert.length;j++){
                    letter = toconvert.substring(j,j+1);
                    newLetter = createletter (letter); 

                    if (newLetter){
                        setposition (newLetter);
                        newLetter.move (newLayer, ElementPlacement.PLACEATEND)
                    } else {
                        if (letter.charCodeAt(0) == 13) {
                            line += linespace;
                            pos = 0;
                        } else pos += wordspace;
                    }
                }
                line += linespace;
                pos = 0;
            }
        }
    } else {
        alert("Select some text object to convert");
    }
}



